using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;
using System.Data.SqlClient;

namespace UpdateInfoRequestService
{
    public class UpdateInfoServiceException : System.Exception {
        public UpdateInfoServiceException(string sMessage):base(sMessage){
 
        }
    }


	/// <summary>
	/// Summary description for Service1.
	/// </summary>
	///     
    [WebService(Namespace="http://boost.net/webservices/")]
	public class UpdateInfoRequestClass : System.Web.Services.WebService
	{

        UpdateInfoServiceException bseNoRows;
        int intRowsAffected;

		public UpdateInfoRequestClass()
		{
            try{
                //CODEGEN: This call is required by the ASP.NET Web Services Designer
                InitializeComponent();
                bseNoRows = new UpdateInfoServiceException("No rows resulted from query");
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
            }
		}

        [WebMethod]
        public DataSet UpdateInfoRequest(DataSet dsChanges) {
            
            try {
                dsChanges.WriteXml("c:\\passedxml.xml");
                SqlConnection cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                SqlDataAdapter da = new SqlDataAdapter();
                SqlCommand UpdateCmd = new SqlCommand("InfoRequestUpdate", cn);
                byte byS = 0;
                byte byP = 0;
                DataView dv = new DataView(dsChanges.Tables[0]);
                dv.RowStateFilter = DataViewRowState.Added;
                Debug.WriteLine("Inserts:" + dv.Count);
                if (dv.Count > 0) {
                    SqlCommand InsertCmd = new SqlCommand("InfoRequestInsert", cn);
                    InsertCmd.CommandType = CommandType.StoredProcedure;
                
                    InsertCmd.Parameters.Add(new SqlParameter("@CustID", SqlDbType.Int, 2, ParameterDirection.Input, false, byS, byP, "CustID", DataRowVersion.Current, null));
                    InsertCmd.Parameters.Add(new SqlParameter("@ISBN", SqlDbType.VarChar, 20, ParameterDirection.Input, false, byS, byP, "ISBN", DataRowVersion.Current, null));
                    InsertCmd.Parameters.Add(new SqlParameter("@DateRequested", SqlDbType.SmallDateTime, 20, ParameterDirection.Input, false, byS, byP, "DateRequested", DataRowVersion.Current, null));
                    InsertCmd.Parameters.Add(new SqlParameter("@DateShipped", SqlDbType.SmallDateTime, 20, ParameterDirection.Input, false, byS, byP, "DateShipped", DataRowVersion.Current, null));
                
                    da.InsertCommand = InsertCmd;
                    Debug.WriteLine("Insert command:" + da.InsertCommand.CommandText);
                    }
                dv.RowStateFilter = DataViewRowState.ModifiedOriginal;
                Debug.WriteLine("Updates:" + dv.Count);
                if (dv.Count > 0) {
                    UpdateCmd.CommandType = CommandType.StoredProcedure;
               
                    UpdateCmd.Parameters.Add(new SqlParameter("@PreviousID", SqlDbType.Int, 2, ParameterDirection.Input, false, byS, byP, "ID", DataRowVersion.Original, 0));
                    UpdateCmd.Parameters.Add(new SqlParameter("@CustID", SqlDbType.Int, 2, ParameterDirection.Input, false, byS, byP, "CustID", DataRowVersion.Current, null));
                    UpdateCmd.Parameters.Add(new SqlParameter("@ISBN", SqlDbType.VarChar, 20, ParameterDirection.Input, false, byS, byP, "ISBN", DataRowVersion.Current, null));
                    UpdateCmd.Parameters.Add(new SqlParameter("@DateRequested", SqlDbType.SmallDateTime, 20, ParameterDirection.Input, false, byS, byP, "DateRequested", DataRowVersion.Current, null));
                    UpdateCmd.Parameters.Add(new SqlParameter("@DateShipped", SqlDbType.SmallDateTime, 20, ParameterDirection.Input, false, byS, byP, "DateShipped", DataRowVersion.Current, null));
                    UpdateCmd.Parameters.Add(new SqlParameter("@PreviousTimeStamp", SqlDbType.Timestamp, 8, ParameterDirection.Input, false, byS, byP, "TimeStamp", DataRowVersion.Original, null));
                
                    da.UpdateCommand = UpdateCmd;
                }
                dv.RowStateFilter = DataViewRowState.Deleted;
                Debug.WriteLine("Deletes:" + dv.Count);
                if( dv.Count > 0) {
                    SqlCommand DeleteCmd = new SqlCommand("InfoRequestDelete", cn);
                    DeleteCmd.CommandType = CommandType.StoredProcedure;
                
                    DeleteCmd.Parameters.Add(new SqlParameter("@PreviousID", SqlDbType.Int, 2, ParameterDirection.Input, false, byS, byP, "ID", DataRowVersion.Original, 0));
                    DeleteCmd.Parameters.Add(new SqlParameter("@PreviousTimeStamp", SqlDbType.Timestamp, 8, ParameterDirection.Input, false, byS, byP, "TimeStamp", DataRowVersion.Original, null));
                
                    da.DeleteCommand = DeleteCmd;
                }
                dv.RowStateFilter = DataViewRowState.None;
                da.ContinueUpdateOnError = true;
                Debug.WriteLine("Changes?" + dsChanges.HasChanges().ToString());
                intRowsAffected = da.Update(dsChanges, "InfoRequest");
                Debug.WriteLine("Errors?" + dsChanges.HasErrors.ToString());
                
                
            }
            catch ( Exception exg) {
                Debug.WriteLine(exg.Message);
                throw exg ;
            }

              return (dsChanges);

        
        }


		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion


	}
}
